<?php
/* --------------------------------------------------------------
   ImageProcessingSettings.php 2023-01-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\Model;

/**
 * Class ImageProcessingSettings
 *
 * @package Gambio\Admin\Modules\ImageProcessing\Model
 */
class ImageProcessingSettings
{
    /**
     * ImageProcessingSettings constructor.
     *
     * @param string $sourcePath
     * @param string $destinationPath
     */
    public function __construct(
        private string $sourcePath,
        private string $destinationPath,
        private int    $newWidth,
        private int    $newHeight
    )
    {
    }


    /**
     * @return string
     */
    public function sourcePath(): string
    {
        return $this->sourcePath;
    }


    /**
     * @return string
     */
    public function destinationPath(): string
    {
        return $this->destinationPath;
    }

    /**
     * @return int
     */
    public function newWidth(): int
    {
        return $this->newWidth;
    }

    /**
     * @return int
     */
    public function newHeight(): int
    {
        return $this->newHeight;
    }
}